/** @file   predatoralien.h
 * @brief   Declarations of PredatorAlien - class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:42 $
 * @author  Tomi Lamminsaari
 */
 
#ifndef PREDATORALIEN_H
#define PREDATORALIEN_H

#include "alien.h"

namespace WeWantWar {

/** @class  PredatorAlien
 * @brief   PredatorAlien is like CarnivoreAlien but stronger and bigger.
 * @author  Tomi Lamminsaari
 *
 */
class PredatorAlien : public Alien
{
public:

  ///
  /// Constructor, destructor
  /// =======================
  
  /** Constructor.
   */
  PredatorAlien();
  
  /** Destructor.
   */
  virtual ~PredatorAlien();
  
  
  ///
  /// Methods
  /// =======
  
  /** Updates the PredatorAlien.
   */
  virtual void update();
  
  /** Kills this alien.
   */
  virtual void kill();
  
  /** Makes sound
   * @param     id                ID of the sound we should make.
   */
  virtual void makeSound( GameObject::SoundID id ) const;
  
  /** This alien got hit by given bullet. The bullets can go through the
   * Alien if it was shot by another alien.
   * @param     pB                Pointer to bullet that hit us.
   * @return    'true' if this bullet did hit us. 'false' means it went
   *            through.
   */
  virtual bool hitByBullet( Bullet* pB );
  
  /** Redraws this Alien. If the graphics vector has not been set, this
   * method will crash. Use @c setGraphics - method to set the graphics.
   * @param     pQueue            Pointer to redraw queue
   */
  virtual void redraw( RedrawQueue* pQueue );
  
  
  
  ///
  /// Getter methods
  /// ==============
  
  /** Returns the ID of this alien.
   * @return    ObjectID::TYPE_PREDATORALIEN
   */
  virtual ObjectID::Type objectType() const;
  

  
protected:

  /** Sets the requested animation
   * @param     aAnimId           Id of the animation
   */
  virtual void setCorrectAnimation( int aAnimId );
  
  /** Attacks the target.
   */
  virtual void attack();
  
  
  
  ///
  /// Members
  /// =======
  
  /** How much damage this alien causes to the player. */
  int   m_damagePoints;
  /** Movement vector. */
  eng2d::Vec2D  m_spdVec;
  
  
private:
  /** Disabled copy constructor. */
  PredatorAlien( const PredatorAlien& rO );
  /** Disabled assignment operator */
  PredatorAlien& operator = ( const PredatorAlien& rO );
};

};  // end of namespace

#endif // PREDATORALIEN_H

